//    wstring.h - support for delphi widestrings in c++
//                (WideString)
// 1.1
//    copyright (c) 1997, 1999 Borland International

#ifndef WSTRING_H
#define WSTRING_H

#pragma delphiheader begin

#include <sysmac.h>
#include <dstring.h>

#define WIDESTRING_IS_BSTR

namespace System
{
  class RTL_DELPHIRETURN WideString
  {
    //friend WideString __fastcall PACKAGE operator +(const wchar_t*, const WideString& rhs); //!! not implemented?
  public:
    // Constructors
    //
    __fastcall WideString(): Data(0) {}
    __fastcall WideString(const char* src);
    __fastcall WideString(const WideString& src);
    __fastcall WideString(const AnsiString& src);
    __fastcall WideString(const WideChar* src, int len);
    __fastcall WideString(const WideChar* src);
#if !defined(WIDECHAR_IS_WCHAR)
    __fastcall WideString(const wchar_t* src, int len);
    __fastcall WideString(const wchar_t* src);
#endif
    __fastcall explicit WideString(char src);
    __fastcall explicit WideString(short src);
    __fastcall explicit WideString(unsigned short);
    __fastcall explicit WideString(int src);
    __fastcall explicit WideString(unsigned int);
    __fastcall explicit WideString(long);
    __fastcall explicit WideString(unsigned long);
    __fastcall explicit WideString(__int64);
    __fastcall explicit WideString(unsigned __int64);
    __fastcall explicit WideString(float src);
    __fastcall explicit WideString(double src);
    __fastcall explicit WideString(long double src);

    // Destructor
    //
    __fastcall ~WideString();

    // Assignments
    //
    WideString& __fastcall operator =(const WideString& rhs);
    WideString& __fastcall operator +=(const WideString& rhs);
#ifdef WIDESTRING_IS_BSTR
    WideString& __fastcall operator =(BSTR              rhs);
#endif

#if 0
    // FIXME: remove these.  but first, we want to be sure that the new
    // global operators aren't introducing a ton of ambiguity problems
    // in existing code.
    // --xmsb (2002-01-24 23:08)

    // Comparisons
    //
    bool __fastcall operator ==(const WideString& rhs) const;
    bool __fastcall operator !=(const WideString& rhs) const;
    bool __fastcall operator < (const WideString& rhs) const;
    bool __fastcall operator > (const WideString& rhs) const;
    bool __fastcall operator <=(const WideString& rhs) const;
    bool __fastcall operator >=(const WideString& rhs) const;
#endif

  public:

    // FIXME: add all AnsiString functionality
    // --xmsb (2002-01-24 23:08)

    // Index
    //
    WideChar & __fastcall operator [](const int idx) { return Data[idx-1]; }

    // Concatenation
    //
    WideString __fastcall operator +(const WideString& rhs) const;

    // Access Data
    //
    bool __fastcall IsEmpty() const { return Data == 0; }
    // Careful! direct acces to internal data
    WideChar* __fastcall data()                    { return Data; }

    WideChar* __fastcall c_bstr() const            { return Data; }

    // Access internal data (Be careful when using!!)
    //
#ifdef WIDESTRING_IS_BSTR
    // these are definitely going away:  we can either act like a BSTR
    // or a Pascal WideString.  the former is what we need.
    // --xmsb (2002-01-24 23:06)
    BSTR* __fastcall operator& ()
    {
      return &Data;
    }
    
    // Attach/Detach from BSTR, Empty Object
    //
    void __fastcall Attach(wchar_t* src);
    BSTR __fastcall Detach();
    void __fastcall Empty();

    // Retrieve copy of data
    //
    static wchar_t* __fastcall Copy(wchar_t* src);

    wchar_t* __fastcall Copy() const
    {
      return Copy(Data);
    }
#endif
    wchar_t* __fastcall Copy(wchar_t *, int len) const;

    // Query attributes of object
    //
    int  __fastcall Length() const;

    // Modify string
    //
    void __fastcall Insert(const WideString& str, int index);
    void __fastcall Delete(int index, int count);
    void __fastcall SetLength(int newLength);

    int  __fastcall Pos(const WideString& subStr) const;
    WideString __fastcall SubString(int index, int count) const;

  private:
    // Initialize from a zero-terminated wide string
    void __fastcall InitStr(const WideChar*, int);
    WideChar* Data;
  };
  
  bool __fastcall operator ==(const WideString& lhs, const WideString& rhs);
  bool __fastcall operator !=(const WideString& lhs, const WideString& rhs);
  bool __fastcall operator < (const WideString& lhs, const WideString& rhs);
  bool __fastcall operator > (const WideString& lhs, const WideString& rhs);
  bool __fastcall operator <=(const WideString& lhs, const WideString& rhs);
  bool __fastcall operator >=(const WideString& lhs, const WideString& rhs);
}
using namespace System;
#pragma delphiheader end.

#endif




